/* Copyright 2008 Thomas Bergwinkl
 *
 * This file is part of bergphoto.
 *
 * bergphoto is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * bergphoto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with bergphoto.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef CANONCR2_H_
#define CANONCR2_H_

#include <QIODevice>
#include <QMap>
#include <QString>

#include <Image.h>
#include <ImageFilter.h>
#include <Metadata.h>

#include <RawFile.h>
#include <Tiff.h>

class CanonCr2 {
public:
	static QString namespaceUri;

	static MetadataQName propertyColorBalance;
	static MetadataQName propertyBodyInfo;
	static MetadataQName propertySensorInfo;
	static MetadataQName propertyShotInfo;
	static MetadataQName propertySensorPlanes;
	static MetadataQName propertyDefaultWhiteBalanceNeutral5200K;
};

class CanonCr2Image : public BayerImage16 {

	Q_OBJECT

public:
	CanonCr2Image(int width, int height);
	virtual ~CanonCr2Image();

	static QString format() {
		return QString("CanonCr2");
	}
};

class CanonCr2Parser : public TiffParser {
public:
	static QMap<int, QString> createMakerNodeTagNameMap();

	CanonCr2Parser(QIODevice* device);

protected:
	static QMap<int, QString> _makerNodeTagNameMap;

	virtual MetadataQName tagQName(quint16 tag);

	virtual void parseMakerNote(MetadataNode* parent, quint32 offset);
};

class CanonCr2File : public RawFile {
public:
	CanonCr2File(QIODevice* device);
	virtual ~CanonCr2File();

	virtual MetadataDocument* readMetadata();
	virtual Image* readImage();

private:
	QIODevice* _device;
	CanonCr2Parser* _canonCr2Parser;
};

class Cr2BayerConverter : public ImageFilter {
public:
	virtual QString name();
	virtual bool accepts(QString inputFormat, QString outputFormat);
	virtual Image* filter(Image* input, QString outputFormat);
};

class CanonCr2MetadataCleanupTransform : public MetadataTransform {
public:
	virtual ~CanonCr2MetadataCleanupTransform();

	virtual MetadataNode* transform(MetadataNode* source);
};

#endif /*CANONCR2_H_*/
