/* Copyright 2008 Thomas Bergwinkl
 *
 * This file is part of bergphoto.
 *
 * bergphoto is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * bergphoto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with bergphoto.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef WIDGETS_H_
#define WIDGETS_H_

#include <QImage>
#include <QList>
#include <QMouseEvent>
#include <QPaintEvent>
#include <QPointF>
#include <QResizeEvent>
#include <QWidget>

#include <BergPhoto.h>
#include <ColorMath.h>

#include <ui_widgetDevelopParameters.h>
#include <ui_widgetImageWriterParameters.h>

class ImageWidget : public QWidget {

	Q_OBJECT

public:
	ImageWidget(QWidget* parent);
	virtual ~ImageWidget();

	QImage* image();
	void setImage(QImage* image);

signals:
	void outputSizeChanged(int width, int height);

protected:
	void paintEvent(QPaintEvent* paintEvent);
	void resizeEvent(QResizeEvent* resizeEvent);

private:
	QImage* _image;
};

class SplineWidget : public QWidget, public Spline {

	Q_OBJECT

public:
	SplineWidget(QWidget* parent);
	SplineWidget(Spline &spline, QWidget* parent);
	virtual ~SplineWidget();

public slots:
	virtual void setPoints(QList<QPointF> list, double scale=1.0);

signals:
	void curveChanged(Spline spline);

protected:
	void mouseMoveEvent(QMouseEvent* mouseEvent);
	void mousePressEvent(QMouseEvent* mouseEvent);
	void mouseReleaseEvent(QMouseEvent* mouseEvent);
	void paintEvent(QPaintEvent* paintEvent); 

private:
	int _dragPointIndex;
	int _pointRadius;
};

class DevelopParametersWidget : public QWidget {

	Q_OBJECT

public:
	DevelopParametersWidget(QWidget* parent);
	virtual ~DevelopParametersWidget();

	QString outputProfile();
	void setOutputProfile(QString outputProfile);

	BergPhoto::Parameters parameters();
	void setParameters(BergPhoto::Parameters parameters);

public slots:
	void updateComboBoxOutputProfileValues();

private:
	Ui::FormDevelopParameters _formDevelopParameters;
};

class ImageWriterParametersWidget : public QWidget {

	Q_OBJECT

public:
	ImageWriterParametersWidget(QWidget* parent);
	virtual ~ImageWriterParametersWidget();

	QString imageWriter();
	void setImageWriter(QString imageWriter);

	QString fileFormat();
	void setFileFormat(QString fileFormat);

	bool compress();
	void setCompress(bool compress);

	int quality();
	void setQuality(int quality);

	BergPhoto::Parameters parameters();
	void setParameters(BergPhoto::Parameters parameters);

public slots:
	void updateComboBoxImageWriter();
	void updateComboBoxFileFormat();
	void updateComboBoxFileFormat(QString dummy);

private:
	Ui::FormImageWriterParameters _formImageWriterParameters;
};

#endif /*WIDGETS_H_*/
