/* Copyright 2008 Thomas Bergwinkl
 *
 * This file is part of bergphoto.
 *
 * bergphoto is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * bergphoto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with bergphoto.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef DNG_H_
#define DNG_H_

#include <QIODevice>
#include <QMap>
#include <QString>

#include <Image.h>
#include <Metadata.h>
#include <RawFile.h>
#include <Tiff.h>

class DNG {
public:
	static QString namespaceUri;
	static MetadataQName propertyUniqueCameraModel;
	static MetadataQName propertyLocalizedCameraModel;
	static MetadataQName propertyCFALayout;
	static MetadataQName propertyBlackLevel;
	static MetadataQName propertyWhiteLevel;
	static MetadataQName propertyBaselineExposure;
	static MetadataQName propertyBaselineNoise;
	static MetadataQName propertyBaselineSharpness;
	static MetadataQName propertyBayerGreenSplit;
	static MetadataQName propertyLinearResponseLimit;
	static MetadataQName propertyCameraSerialNumber;
	static MetadataQName propertyAntiAliasStrength;
	static MetadataQName propertyShadowScale;
	static MetadataQName propertyCalibrationIlluminant1;
	static MetadataQName propertyCalibrationIlluminant2;
	static MetadataQName propertyBestQualityScale;
	static MetadataQName propertyOriginalRawFileName;
	static MetadataQName propertyOriginalRawFileData;
	static MetadataQName propertyDNGVersion;
	static MetadataQName propertyDNGBackwardVersion;
	static MetadataQName propertyCFAPlaneColor;
	static MetadataQName propertyBlackLevelRepeatDim;
	static MetadataQName propertyBlackLevelDeltaV;
	static MetadataQName propertyDefaultScale;
	static MetadataQName propertyDefaultCropOrigin;
	static MetadataQName propertyDefaultCropSize;
	static MetadataQName propertyColorMatrix1;
	static MetadataQName propertyColorMatrix2;
	static MetadataQName propertyCameraCalibration1;
	static MetadataQName propertyCameraCalibration2;
	static MetadataQName propertyAnalogBalance;
	static MetadataQName propertyAsShotNeutral;
	static MetadataQName propertyLensInfo;
	static MetadataQName propertyDNGPrivateData;
	static MetadataQName propertyRawDataUniqueID;
	static MetadataQName propertyActiveArea;
	static MetadataQName propertyMaskedAreas;
};

class DNGParser : public TiffParser {
public:
	static QMap<int, QString> createTagNameMap();

	DNGParser(QIODevice* device);

protected:
	static QMap<int, QString> _tagNameMap;

	virtual MetadataQName tagQName(quint16 tag);
};

class DNGFile : public RawFile {
public:
	DNGFile(QIODevice* device);
	virtual ~DNGFile();

	virtual MetadataDocument* readMetadata();
	virtual Image* readImage();

private:
	QIODevice* _device;
	DNGParser* _dngParser;
};

class DNGMetadataCleanupTransform : public MetadataTransform {
public:
	virtual ~DNGMetadataCleanupTransform();

	virtual MetadataNode* transform(MetadataNode* source);
};

#endif /*DNG_H_*/
