/* Copyright 2008 Thomas Bergwinkl
 *
 * This file is part of bergphoto.
 *
 * bergphoto is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * bergphoto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with bergphoto.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "ColorManagement.h"

CmsProfile::CmsProfile(cmsHPROFILE lcmsProfile) {
	_lcmsProfile = lcmsProfile;
}

CmsProfile::CmsProfile(QString filename) {
	_lcmsProfile = cmsOpenProfileFromFile(filename.toAscii().data(), "r");
}

CmsProfile::~CmsProfile() {
	cmsCloseProfile(_lcmsProfile);
}

void CmsProfile::setDeviceManufacturerDescription(QString deviceManufacturerDescription) {
	cmsAddTag(_lcmsProfile, icSigDeviceMfgDescTag, (LPVOID)deviceManufacturerDescription.toAscii().data());
}

void CmsProfile::setDeviceModelDescription(QString deviceModelDescription) {
	cmsAddTag(_lcmsProfile, icSigDeviceModelDescTag, (LPVOID)deviceModelDescription.toAscii().data());
}

void CmsProfile::setProfileDescription(QString profileDescription) {
	cmsAddTag(_lcmsProfile, icSigProfileDescriptionTag, (LPVOID)profileDescription.toAscii().data());
}

QByteArray CmsProfile::toByteArray(int maxSize) {
	QByteArray data;
	size_t size;

	data.resize(maxSize);

	_cmsSaveProfileToMem(_lcmsProfile, (void*)data.data(), &size);

	data.resize((int)size);

	return data;
}

cmsHPROFILE CmsProfile::lcmsProfile() {
	return _lcmsProfile;
}

CmsProfile* CmsProfile::proPhotoLinearRgbProfile() {
	cmsCIExyY whitePoint;
	cmsWhitePointFromTemp(5003, &whitePoint);

	cmsCIExyYTRIPLE primaries = {
		{ 0.7347, 0.2653, 0.288040 },
		{ 0.1596, 0.8404, 0.711874 },
		{ 0.0366, 0.0001, 0.000086 }
	};

	LPGAMMATABLE gamma[3];
	gamma[0] = gamma[1] = gamma[2] = cmsBuildGamma(2, 1.0);

	CmsProfile* profile = new CmsProfile(cmsCreateRGBProfile(&whitePoint, &primaries, gamma));

	profile->setDeviceManufacturerDescription("bergphoto");
	profile->setDeviceModelDescription("bergphoto");
	profile->setProfileDescription("linear ProPhoto");

	return profile;
}

CmsProfile* CmsProfile::sRgbProfile() {
	return new CmsProfile(cmsCreate_sRGBProfile());
}


CmsProfile* CmsProfile::adobeRgbProfile() {
	cmsCIExyY whitePoint;
	cmsWhitePointFromTemp(6504, &whitePoint);

	cmsCIExyYTRIPLE primaries = {
		{ 0.6400, 0.3300, 0.297361 },
		{ 0.2100, 0.7100, 0.627355 },
		{ 0.1500, 0.0600, 0.075285 }
	};

	LPGAMMATABLE gamma[3];
	gamma[0] = gamma[1] = gamma[2] = cmsBuildGamma(1024, 2.2);

	return new CmsProfile(cmsCreateRGBProfile(&whitePoint, &primaries, gamma));
}

CmsTransform::CmsTransform(CmsProfile* inProfile, ColorEncoding inEncoding, CmsProfile* outProfile, ColorEncoding outEncoding) {
	_lcmsTransform = cmsCreateTransform(
			inProfile->lcmsProfile(),
            inEncoding,
            outProfile->lcmsProfile(),
            outEncoding,
            INTENT_RELATIVE_COLORIMETRIC,
            0);
}

CmsTransform::~CmsTransform() {
	cmsDeleteTransform(_lcmsTransform);
}

void CmsTransform::transform(void* inBuffer, void* outBuffer, int size) {
	cmsDoTransform(
			_lcmsTransform,
			inBuffer,
			outBuffer,
			size);
}
