/* Copyright 2008 Thomas Bergwinkl
 *
 * This file is part of bergphoto.
 *
 * bergphoto is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * bergphoto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with bergphoto.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef COLORMANAGEMENT_H_
#define COLORMANAGEMENT_H_

#include <QByteArray>
#include <QString>

#include <lcms.h>

class CmsProfile {
public:
	CmsProfile(cmsHPROFILE lcmsProfile);
	CmsProfile(QString filename);
	virtual ~CmsProfile();

	void setDeviceManufacturerDescription(QString deviceManufacturerDescription);
	void setDeviceModelDescription(QString deviceModelDescription);
	void setProfileDescription(QString profileDescription);

	QByteArray toByteArray(int maxSize=1024*1024);

	cmsHPROFILE lcmsProfile();

	static CmsProfile* proPhotoLinearRgbProfile();
	static CmsProfile* sRgbProfile();
	static CmsProfile* adobeRgbProfile();

private:
	cmsHPROFILE _lcmsProfile;
};

class CmsTransform {
public:
	enum ColorEncoding {
		Abgr8 = TYPE_ARGB_8,
		Bgra8 = TYPE_BGRA_8,
		Bgr8 = TYPE_BGR_8,
		Rgb8 = TYPE_RGB_8,
		Rgb16 = TYPE_RGB_16,
		RgbDouble = TYPE_RGB_DBL
	};

	CmsTransform(CmsProfile* inProfile, ColorEncoding inEncoding, CmsProfile* outProfile, ColorEncoding outEncoding);
	virtual ~CmsTransform();

	void transform(void* inBuffer, void* outBuffer, int size);

private:
	cmsHTRANSFORM _lcmsTransform;
};

#endif /*COLORMANAGEMENT_H_*/
