/* Copyright 2008 Thomas Bergwinkl
 *
 * This file is part of bergphoto.
 *
 * bergphoto is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * bergphoto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with bergphoto.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "Dialogs.h"

OutputParametersDialog::OutputParametersDialog(QWidget* parent) : QDialog(parent) {
	_dialogOutputParameters.setupUi(this);
}

OutputParametersDialog::~OutputParametersDialog() {	
}

BergPhoto::Parameters OutputParametersDialog::developParameters() {
	return _dialogOutputParameters.widgetDevelopParameters->parameters();
}

void OutputParametersDialog::setDevelopParameters(BergPhoto::Parameters parameters) {
	_dialogOutputParameters.widgetDevelopParameters->setParameters(parameters);
}

BergPhoto::Parameters OutputParametersDialog::imageWriterParameters() {
	return _dialogOutputParameters.widgetImageWriterParameters->parameters();
}

void OutputParametersDialog::setImageWriterParameters(BergPhoto::Parameters parameters) {
	_dialogOutputParameters.widgetImageWriterParameters->setParameters(parameters);
}
