/* Copyright 2008 Thomas Bergwinkl
 *
 * This file is part of bergphoto.
 *
 * bergphoto is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * bergphoto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with bergphoto.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef DIALOGS_H_
#define DIALOGS_H_

#include <QDialog>

#include <BergPhoto.h>

#include <ui_dialogOutputParameters.h>

class OutputParametersDialog : public QDialog {

	Q_OBJECT

public:
	OutputParametersDialog(QWidget* parent);
	virtual ~OutputParametersDialog();

	BergPhoto::Parameters developParameters();
	void setDevelopParameters(BergPhoto::Parameters parameters);

	BergPhoto::Parameters imageWriterParameters();
	void setImageWriterParameters(BergPhoto::Parameters parameters);

private:
	Ui::DialogOutputParameters _dialogOutputParameters;
};

#endif /*DIALOGS_H_*/
