/* Copyright 2008 Thomas Bergwinkl
 *
 * This file is part of bergphoto.
 *
 * bergphoto is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * bergphoto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with bergphoto.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "Image.h"

Image::Image() {
	_width = -1;
	_height = -1;
	_colorProfile = 0;
	_resource = 0;
}

Image::~Image() {
	if(_colorProfile != 0)
		delete _colorProfile;
}

void Image::setWidth(int width) {
	_width = width;
}

int Image::width() {
	return _width;
}

void Image::setHeight(int height) {
	_height = height;
}

int Image::height() {
	return _height;
}

void Image::setFormat(QString format) {
	_format = format;
}

QString Image::format() {
	return _format;
}

void Image::setColorProfile(CmsProfile* colorProfile) {
	_colorProfile = colorProfile;
}

CmsProfile* Image::colorProfile() {
	return _colorProfile;
}

void Image::setMetadata(MetadataResource* resource) {
	_resource = resource;
}

MetadataResource* Image::metadata() {
	return _resource;
}

RgbImage32::RgbImage32(int width, int height) : Image() {
	_width = width;
	_height = height;
	_format = RgbImage32::format();
	_data = new quint8[_width*_height*4];
}

RgbImage32::~RgbImage32() {
	delete _data;
}

quint8* RgbImage32::data() {
	return _data;
}

quint8* RgbImage32::dataLine(int y) {
	return _data+y*_width*4;
}

quint8* RgbImage32::dataOffset(int x, int y) {
	return _data+(y*_width+x)*4;
}

QImage* RgbImage32::toQImage() {
	return new QImage((uchar*)data(), width(), height(), QImage::Format_RGB32);
}

RgbImage48::RgbImage48(int width, int height) : Image() {
	_width = width;
	_height = height;
	_format = RgbImage48::format();
	_data = new quint16[_width*_height*3];
}

RgbImage48::~RgbImage48() {
	delete _data;
}

quint16* RgbImage48::data() {
	return _data;
}

quint16* RgbImage48::dataLine(int y) {
	return _data+y*_width*3;
}

quint16* RgbImage48::dataOffset(int x, int y) {
	return _data+(y*_width+x)*3;
}
