/* Copyright 2008 Thomas Bergwinkl
 *
 * This file is part of bergphoto.
 *
 * bergphoto is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * bergphoto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with bergphoto.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef IMAGE_H_
#define IMAGE_H_

#include <QImage>
#include <QString>

#include <ColorManagement.h>
#include <Metadata.h>

class Image : public QObject {

	Q_OBJECT

public:
	enum {
		ColorRed = 0,
		ColorGreen = 1,
		ColorBlue = 2
	} Color;

	Image();
	virtual ~Image();

	void setWidth(int width);
	int width();

	void setHeight(int height);
	int height();

	void setFormat(QString format);
	QString format();

	void setColorProfile(CmsProfile* colorProfile);
	CmsProfile* colorProfile();

	void setMetadata(MetadataResource* resource);
	MetadataResource* metadata();

protected:
	int _width;
	int _height;
	QString _format;
	CmsProfile* _colorProfile;
	MetadataResource* _resource;
};

class RgbImage32 : public Image {

	Q_OBJECT

public:
	RgbImage32(int width, int height);
	virtual ~RgbImage32();

	quint8* data();
	quint8* dataLine(int y);
	quint8* dataOffset(int x, int y);

	QImage* toQImage();

	static QString format() {
		return "Rgb32";
	}

private:
	quint8* _data;
};

class RgbImage48 : public Image {

	Q_OBJECT

public:
	RgbImage48(int width, int height);
	virtual ~RgbImage48();

	quint16* data();
	quint16* dataLine(int y);
	quint16* dataOffset(int x, int y);

	static QString format() {
		return "Rgb48";
	}

private:
	quint16* _data;
};

#endif /*IMAGE_H_*/
