/* Copyright 2008 Thomas Bergwinkl
 *
 * This file is part of bergphoto.
 *
 * bergphoto is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * bergphoto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with bergphoto.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef IMAGEFILTER_H_
#define IMAGEFILTER_H_

#include <QMap>
#include <QString>
#include <QVariant>

#include <BergPhoto.h>
#include <Image.h>

class ImageFilter {
public:
	virtual ~ImageFilter();

	virtual QString name() = 0;

	virtual bool accepts(QString inputFormat, QString outputFormat) = 0;

	virtual Image* filter(Image* input, QString outputFormat) = 0;

	virtual BergPhoto::Parameters parameters();

	virtual void setParameters(BergPhoto::Parameters parameters);

protected:
	BergPhoto::Parameters _parameters;
};

class ImageWriter {
public:
	static QString parameterImageWriter;
	static QString parameterFileFormat;
	static QString parameterCompress;
	static QString parameterQuality;

	virtual ~ImageWriter() {
	}

	virtual bool accepts(QString format) = 0;

	virtual bool write(QIODevice* device, Image* image, MetadataResource* resource, BergPhoto::Parameters parameters) = 0;

	virtual bool write(QString fileName, Image* image, MetadataResource* resource, BergPhoto::Parameters parameter);
};

class ResizeFilter : public ImageFilter {
public:
	ResizeFilter();
	virtual ~ResizeFilter();

	virtual QString name();

	virtual bool accepts(QString inputFormat, QString outputFormat);

	virtual Image* filter(Image* input, QString outputFormat);
};

class QtImageWriter : public ImageWriter {
public:
	static QString name;

	virtual bool accepts(QString format);

	virtual bool write(QIODevice* device, Image* image, MetadataResource* resource, BergPhoto::Parameters parameters);	
};

// TODO: implement filterChain

#endif /*IMAGEFILTER_H_*/
