/* Copyright 2008 Thomas Bergwinkl
 *
 * This file is part of bergphoto.
 *
 * bergphoto is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * bergphoto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with bergphoto.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef QTUTILS_H_
#define QTUTILS_H_

#include <QComboBox>
#include <QFile>
#include <QIODevice>
#include <QList>
#include <QString>
#include <QVariant>

class QtUtils {
public:
	static inline QString fileName(QIODevice* device) {
		if(device->inherits("QFile"))
			return qobject_cast<QFile*>(device)->fileName();
		else
			return QString();
	}

	template <typename T> static inline QList<QVariant> toVariantList(QList<T> values) {
		QList<QVariant> list;

		foreach(T value, values) {
			list.append(QVariant(value));
		}

		return list;
	}

	template <typename T>static inline QList<T> toTypedList(QList<QVariant> values) {
		QList<T> list;

		foreach(QVariant value, values) {
			if(value.canConvert<T>())
				list.append(value.value<T>());
		}

		return list;
	}

	static inline void comboBoxClearItemList(QComboBox* comboBox) {
		while(comboBox->count() != 0)
			comboBox->removeItem(comboBox->count()-1);
	}

	static inline void comboBoxSetCurrentItem(QComboBox* comboBox, QString text) {
		for(int i=0; i<comboBox->count(); i++) {
			if(comboBox->itemText(i) == text) {
				comboBox->setCurrentIndex(i);

				return;
			}
		}
	}
};

// missing in qt
Q_DECLARE_METATYPE(qint8);

#endif /*QTUTILS_H_*/
