/* Copyright 2008 Thomas Bergwinkl
 *
 * This file is part of bergphoto.
 *
 * bergphoto is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * bergphoto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with bergphoto.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef RAWIMPORTER_H_
#define RAWIMPORTER_H_

#include <QList>
#include <QMainWindow>
#include <QPointF>

#include <BergPhoto.h>
#include <ColorMath.h>
#include <Image.h>
#include <Metadata.h>

#include <RawFile.h>

#include <ui_rawdev.h>


class RawdevCore {
public:
	RawdevCore();
	~RawdevCore();

	bool fileOpen(QString fileName);
	bool fileClose();
	void saveImage(QString fileName);
	void saveBayerImage(QString fileName);
	void saveMetadata(QString fileName);

	bool imageLoaded();

	int sourceWidth();
	int sourceHeight();

	QList<QPointF> toneCurve();
	void setToneCurve(Spline curve);

	QString whiteBalance();
	void setWhiteBalance(QString whiteBalance);

	int whiteBalanceTemperature();
	void setWhiteBalanceTemperature(int temperature);

	int whiteBalanceTint();
	void setWhiteBalanceTint(int tint);

	BergPhoto::Parameters developParameters();
	void setDevelopParameters(BergPhoto::Parameters parameters);

	BergPhoto::Parameters imageWriterParameters();
	void setImageWriterParameters(BergPhoto::Parameters parameters);

	Image* preview(int width, int height);

private:
	DemosaicFilter _demosaicFilter;
	ExposureFilter _exposureFilter;
	DevelopFilter _developFilter;
	BergPhoto::Parameters _developParameters;
	BergPhoto::Parameters _imageWriterParamters;
	RawFile* _rawFile;
	MetadataResource* _metadataResource;
	MetadataNode* _settingsDefault;
	MetadataNode* _settingsCurrent;
	Image* _debayerImage;
};

class RawdevGui : public QObject {

	Q_OBJECT

public:
	RawdevGui(QMainWindow* mainWindow, RawdevCore* rawdevCore);
	~RawdevGui();

public slots:
	void fileOpen();
	void fileClose();
	void previewImage();
	void previewImageSizeChanged(int width, int height);
	void setRealtimePreview(bool flag);
	void saveImage();
	void setOutputParameters();
	void saveBayerImage();
	void saveMetadata();
	void setToneCurve(Spline curve);
	void setWhiteBalanceMode(QString mode);
	void setWhiteBalanceTemperature(int temperature);
	void setWhiteBalanceTint(int tint);

signals:
	void parametersChanged();

private:
	QMainWindow* _mainWindow;
	Ui::MainWindowRawdev _mainWindowRawdev;

	RawdevCore* _rawdevCore;

	int _previewWidth;
	int _previewHeight;
	Image* _previewImage;

	void syncGui();
};

#endif /*RAWIMPORTER_H_*/
