QT += \
	xml \
	xmlpatterns

CONFIG += \
	qt

HEADERS += \
	src/BergPhoto.h \
	src/ColorManagement.h \
	src/ColorMath.h \
	src/Dialogs.h \
	src/Image.h \
	src/ImageFilter.h \
	src/ImageFilter_p.h \
	src/ImagePreviewWidget.h \
	src/ImagePreviewWidget_p.h \
	src/Metadata.h \
	src/MetadataExifTool.h \
	src/MetadataRdf.h \
	src/QtUtils.h \
	src/RawFile.h \
	src/SimpleImagePreviewWidget.h \
	src/Widgets.h \
	src/filters/DemosaicFilter.h \
	src/filters/DevelopFilter.h \
	src/filters/ExposureFilter.h \
	src/filters/ResizeFilter.h \
	src/filters/RotateCropFilter.h \
	src/formats/CanonCr2.h \
	src/formats/DNG.h \
	src/formats/LosslessJpegDecoder.h \
	src/formats/Tiff.h

SOURCES += \
	src/ColorManagement.cpp \
	src/ColorMath.cpp \
	src/Dialogs.cpp \
	src/Image.cpp \
	src/ImageFilter.cpp \
	src/ImagePreviewWidget.cpp \
	src/Metadata.cpp \
	src/MetadataExifTool.cpp \
	src/MetadataRdf.cpp \
	src/QtUtils.cpp \
	src/RawFile.cpp \
	src/SimpleImagePreviewWidget.cpp \
	src/Widgets.cpp \
	src/filters/DemosaicFilter.cpp \
	src/filters/DevelopFilter.cpp \
	src/filters/ExposureFilter.cpp \
	src/filters/ResizeFilter.cpp \
	src/filters/RotateCropFilter.cpp \
	src/formats/CanonCr2.cpp \
	src/formats/DNG.cpp \
	src/formats/LosslessJpegDecoder.cpp \
	src/formats/Tiff.cpp

FORMS += \
	src/dialogOutputParameters.ui \
	src/widgetDevelopParameters.ui \
	src/widgetSimpleImagePreview.ui \
	src/widgetImageWriterParameters.ui

LIBS += \
	-llcms

# libraw import module
contains(DEFINES, USE_LIBRAW) {
	DEFINES += \
		LIBRAW_NODLL

	HEADERS += \
		src/formats/LibRawFile.h

	SOURCES += \
		src/formats/LibRawFile.cpp

	LIBS += \
		-lraw \
		-lws2_32 \
		-lm 
}

# opengl support
contains(DEFINES, USE_OPENGL) {
	QT += opengl
}
