/* Copyright 2008 Thomas Bergwinkl
 *
 * This file is part of bergphoto.
 *
 * bergphoto is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * bergphoto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with bergphoto.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef IMAGE_H_
#define IMAGE_H_

#include <QImage>
#include <QString>

#include <ColorManagement.h>
#include <Metadata.h>

class ImageFormat {
public:
	ImageFormat(QString type=QString(), int width=-1, int height=-1);

	void setType(QString type);
	QString type();

	void setWidth(int width);
	int width();

	void setHeight(int height);
	int height();

	bool operator ==(ImageFormat o) { return _type == o._type && _width == o._width && _height == o._height; }
	bool operator !=(ImageFormat o) { return !(*this == o); }

private:
	QString _type;
	int _width;
	int _height;
};

class Image : public QObject {

	Q_OBJECT

public:
	enum {
		ColorRed = 0,
		ColorGreen = 1,
		ColorBlue = 2
	} Color;

	static QString namespaceUri;

	static MetadataQName propertyOrientation;

	Image(QObject* parent=0);
	virtual ~Image();

	void setFormat(ImageFormat imageFormat);
	ImageFormat format();

	void setType(QString type);
	QString type();

	void setPixelSize(int pixelSize);
	int pixelSize();

	void setWidth(int width);
	int width();

	void setHeight(int height);
	int height();

	void setStripeSize(int stripeSize);
	int stripeSize();

	quint8* data();
	quint8* dataStripe(int y);
	quint8* dataStripeSave(int y);
	quint8* dataOffset(int x, int y);
	quint8* dataOffsetSave(int x, int y);

	void setColorProfile(CmsProfile* colorProfile);
	CmsProfile* colorProfile();

	void setMetadata(MetadataResource* resource);
	MetadataResource* metadata();

protected:
	QString _type;
	int _pixelSize;

	int _width;
	int _height;
	int _stripeSize;

	quint8* _dataAlloc;
	quint8* _data;

	CmsProfile* _colorProfile;
	MetadataResource* _resource;
};

class RgbImage32 : public Image {

	Q_OBJECT

public:
	RgbImage32(int width, int height, QObject* parent=0);
	virtual ~RgbImage32();

	QImage* toQImage();

	static QString type() {
		return "Rgb32";
	}
};

class RgbImage48 : public Image {

	Q_OBJECT

public:
	RgbImage48(int width, int height, QObject* parent=0);
	virtual ~RgbImage48();

	static QString type() {
		return "Rgb48";
	}
};

#endif /*IMAGE_H_*/
