/* Copyright 2008 Thomas Bergwinkl
 *
 * This file is part of bergphoto.
 *
 * bergphoto is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * bergphoto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with bergphoto.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef IMAGE_FILTER_P_H_
#define IMAGE_FILTER_P_H_

#include <QPointer>
#include <QThread>

#include <Image.h>
#include <ImageFilter.h>

class ImageFilterChainWorkerThread : public QThread {

	Q_OBJECT

public:
	ImageFilterChainWorkerThread(ImageFilterChain* imageFilterChain, QObject* parent=0);

	void run();

public slots:
	void start(QThread::Priority priority=QThread::InheritPriority);

signals:
	void finished(Image*);

private:
	volatile bool _run;
	QPointer<ImageFilterChain> _imageFilterChain;
};

#endif /*IMAGE_FILTER_P_H_*/
