/* Copyright 2008 Thomas Bergwinkl
 *
 * This file is part of bergphoto.
 *
 * bergphoto is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * bergphoto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with bergphoto.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef IMAGE_PREVIEW_WIDGET_H_
#define IMAGE_PREVIEW_WIDGET_H_

#include <QGraphicsScene>
#include <QGraphicsView>

#include <ImageFilter.h>
#include <QtUtils.h>

class ImagePreviewImageItem;

class ImagePreviewFilterChainBridge : public QObject {

	Q_OBJECT

public:
	ImagePreviewFilterChainBridge(QObject* parent=0, ImageFilterChain* imageFilterChain=0);

	void setImageFilterChain(ImageFilterChain* imageFilterChain);

	MetadataNode* settingsCurrent();

public slots:
	void setPropertyValue(MetadataQName qName, QVariant value, MetadataNode* parent=0);

	void parameterChange(QString key, QVariant value);

	void metadataPropertyChange(MetadataProperty* property);

	void setScale(double scale);

	void setDefaultImageSize(QSize defaultImageSize);

	void setOrientation(double orientation);

	void setRotateAngle(double angle);

	void setCropTop(int cropTop);

	void setCropLeft(int cropLeft);

	void setCropBottom(int cropBottom);

	void setCropRight(int cropRight);

	void refresh();

signals:
	void scaleChanged(double);
	void scaleChanged();

	void defaultImageSizeChanged(QSize);
	void defaultImageSizeChanged();

	void orientationChanged(double);
	void orientationChanged();

	void rotateAngleChanged(double);
	void rotateAngleChanged();

	void cropTopChanged(int);
	void cropTopChanged();

	void cropLeftChanged(int);
	void cropLeftChanged();

	void cropBottomChanged(int);
	void cropBottomChanged();

	void cropRightChanged(int);
	void cropRightChanged();

private:
	MetadataResource* metadata();

	QPointer<ImageFilterChain> _imageFilterChain;
};

class ImagePreviewWidget : public QGraphicsView {

	Q_OBJECT
	Q_PROPERTY(bool viewCropLines READ viewCropLines WRITE setViewCropLines)
	Q_PROPERTY(double scale READ scale WRITE setScale)

public:
	ImagePreviewWidget(QWidget* parent);
	virtual ~ImagePreviewWidget();

	void setFilterChain(ImageFilterChain* filterChain);

	virtual bool event(QEvent* event);

	void setBackgroundBrush(const QBrush& brush);

public slots:
	bool viewCropLines() { return _viewCropLines; };
	void setViewCropLines(bool flag=true);

	double scale() { return _scale; };
	void setScale(double scale);

signals:
	void maxImageSizeChanged(QSize);

	void scaleChanged(double);

private slots:
	void updateImageItem();

	void renderImage();
	void imageRendered(Image* image);

	void updateImageSize();

protected:
	virtual void resizeEvent(QResizeEvent* resizeEvent);
	virtual void wheelEvent(QWheelEvent* wheelEvent);

private:
	QPointer<ImageFilterChain> _filterChain;
	ImagePreviewFilterChainBridge* _filterChainBridge;
	QImage* _qImage;
	bool _viewCropLines;
	double _scale;
	double _widgetScale;
	QExtDoubleContainer _filterScale;

	QExtDoubleContainer _orientation;
	QExtDoubleContainer _rotateAngle;
	QExtIntContainer _cropTop;
	QExtIntContainer _cropRight;
	QExtIntContainer _cropBottom;
	QExtIntContainer _cropLeft;
	QExtSizeContainer _defaultImageSize;

	QSize _maxImageSize;

	QGraphicsScene* _graphicsScene;
	ImagePreviewImageItem* _graphicsImageItem;
	QGraphicsRectItem* _cropRectItem;
	QGraphicsRectItem* _cropRectTopItem;
	QGraphicsRectItem* _cropRectLeftItem;
	QGraphicsRectItem* _cropRectBottomItem;
	QGraphicsRectItem* _cropRectRightItem;
	QPointF _imagePosition;
};

#endif /* IMAGE_PREVIEW_WIDGET_H_ */
