/* Copyright 2008 Thomas Bergwinkl
 *
 * This file is part of bergphoto.
 *
 * bergphoto is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * bergphoto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with bergphoto.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef IMAGE_PREVIEW_WIDGET_P_H_
#define IMAGE_PREVIEW_WIDGET_P_H_

#include <QCoreApplication>
#include <QEvent>
#include <QGraphicsItem>
#include <QGraphicsSceneMouseEvent>

class ImagePreviewImagePositionEvent : public QEvent {
public:
	ImagePreviewImagePositionEvent(QPointF pos) : QEvent(eventId()) {
		_pos = pos;
	}

	QPointF pos() { return _pos; }

public:
	static QEvent::Type eventId() { return (QEvent::Type)_eventId; }

private:
	QPointF _pos;

private:
	static int _eventId;
};

class ImagePreviewImageItem : public QGraphicsItem {
public:
	ImagePreviewImageItem(QImage* image=0) {
		setImage(image);
	}

	~ImagePreviewImageItem() { }

	QImage* image() { return _image; }

	void setImage(QImage* image) {
		_image = image;

		if(_image == 0)
			return;

		_image->setOffset(_image->rect().center());
	}

	QRectF boundingRect() const {
		if(_image == 0)
			return QRectF();

		return QRectF(-_image->offset(), _image->size());
	}

	void paint(QPainter* painter, const QStyleOptionGraphicsItem* option, QWidget* widget) {
		Q_UNUSED(widget);

		if(_image == 0)
			return;

		QRectF exposed = option->exposedRect.adjusted(-1, -1, 1, 1);
		exposed &= boundingRect();
		painter->drawImage(exposed, *_image, exposed.translated(_image->offset()));
	}

	void setEventHandler(QObject* callback) { _eventHandler = callback; }

protected:
	void mouseMoveEvent(QGraphicsSceneMouseEvent* event) {
		QGraphicsItem::mouseMoveEvent(event);

		if(!_eventHandler.isNull())
			QCoreApplication::postEvent(_eventHandler, new ImagePreviewImagePositionEvent(pos()));
	}

protected:
	QImage* _image;
	QPointer<QObject> _eventHandler;
};

#endif /* IMAGE_PREVIEW_WIDGET_P_H_ */
