/* Copyright 2008 Thomas Bergwinkl
 *
 * This file is part of bergphoto.
 *
 * bergphoto is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * bergphoto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with bergphoto.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef METADATAEXIFTOOL_H_
#define METADATAEXIFTOOL_H_

#include <Metadata.h>

class MetadataExifTool: public MetadataReader {
public:
	MetadataExifTool(QString fileName=QString(), QString exifTool=QString());
	virtual ~MetadataExifTool();

	void setFileName(QString fileName);
	void setExifTool(QString exifTool);

	virtual MetadataNode* read(MetadataNode* parent=0);

	static MetadataNode* readFile(QString fileName, QString exifTool=QString());

	static QString namespaceUri;

protected:
	QString _fileName;
	QString _exifTool;

	virtual QVariant translateValue(QString key, QString value);

	static QMap<QString, MetadataQName> keyQNameMap();

	static QMap<QString, MetadataQName> _keyQNameMap;
};

#endif /* METADATAEXIFTOOL_H_ */
