/* Copyright 2008 Thomas Bergwinkl
 *
 * This file is part of bergphoto.
 *
 * bergphoto is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * bergphoto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with bergphoto.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "QtUtils.h"

QExtDoubleSlider::QExtDoubleSlider(QWidget* parent) : QSlider(parent) {
	_doubleScale = 1.0;

	connect(this, SIGNAL(valueChanged(int)), this, SLOT(integerBridge(int)));
}

double QExtDoubleSlider::doubleValue() {
	return value() / _doubleScale;
}

double QExtDoubleSlider::doubleScale() {
	return _doubleScale;
}

void QExtDoubleSlider::setDoubleValue(double doubleValue) {
	if(qRound(doubleValue * _doubleScale) == value())
		return;

	setValue((int)(qRound(doubleValue * _doubleScale)));
}

void QExtDoubleSlider::setDoubleScale(double doubleScale) {
	if(doubleScale == _doubleScale)
		return;

	_doubleScale = doubleScale;

	emit doubleScaleChanged(_doubleScale);
}

void QExtDoubleSlider::integerBridge(int integerValue) {
	emit doubleValueChanged(integerValue / _doubleScale);
}

QExtIntContainer::QExtIntContainer(int value) {
	_value = value;
}

int QExtIntContainer::value() {
	return _value;
}

void QExtIntContainer::setValue(int value) {
	if(value == _value)
		return;

	_value = value;

	emit valueChanged(_value);
	emit valueChanged();
}

QExtDoubleContainer::QExtDoubleContainer(double value) {
	_value = value;
}

double QExtDoubleContainer::value() {
	return _value;
}

void QExtDoubleContainer::setValue(double value) {
	if(value == _value)
		return;

	_value = value;

	emit valueChanged(_value);
	emit valueChanged();
}

QExtSizeContainer::QExtSizeContainer(QSize value) {
	_value = value;
}

QSize QExtSizeContainer::value() {
	return _value;
}

void QExtSizeContainer::setValue(QSize value) {
	if(value == _value)
		return;

	_value = value;

	emit valueChanged(_value);
	emit valueChanged();
}
