/* Copyright 2008 Thomas Bergwinkl
 *
 * This file is part of bergphoto.
 *
 * bergphoto is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * bergphoto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with bergphoto.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef QTUTILS_H_
#define QTUTILS_H_

#include <QComboBox>
#include <QFile>
#include <QIODevice>
#include <QList>
#include <QSize>
#include <QString>
#include <QVariant>

class QtUtils {
public:
	static inline QString fileName(QIODevice* device) {
		if(device->inherits("QFile"))
			return qobject_cast<QFile*>(device)->fileName();
		else
			return QString();
	}

	template <typename T> static inline QList<QVariant> toVariantList(QList<T> values) {
		QList<QVariant> list;

		foreach(T value, values) {
			list.append(QVariant(value));
		}

		return list;
	}

	template <typename T> static inline QList<T> toTypedList(QList<QVariant> values) {
		QList<T> list;

		foreach(QVariant value, values) {
			if(value.canConvert<T>())
				list.append(value.value<T>());
		}

		return list;
	}

	static inline void comboBoxClearItemList(QComboBox* comboBox) {
		while(comboBox->count() != 0)
			comboBox->removeItem(comboBox->count()-1);
	}

	static inline void comboBoxSetCurrentItem(QComboBox* comboBox, QString text) {
		for(int i=0; i<comboBox->count(); i++) {
			if(comboBox->itemText(i) == text) {
				comboBox->setCurrentIndex(i);

				return;
			}
		}
	}
};

class QExtDoubleSlider : public QSlider {

	Q_OBJECT
	Q_PROPERTY(double doubleValue READ doubleValue WRITE setDoubleValue)
	Q_PROPERTY(double doubleScale READ doubleScale WRITE setDoubleScale)

public:
	QExtDoubleSlider(QWidget* parent=0);

	double doubleValue();
	double doubleScale();

public slots:
	void setDoubleValue(double doubleValue);
	void setDoubleScale(double doubleScale);

signals:
	void doubleValueChanged(double);
	void doubleScaleChanged(double);

private slots:
	void integerBridge(int integerValue);

protected:
	double _doubleScale;
};

class QExtIntContainer : public QObject {

	Q_OBJECT
	Q_PROPERTY(int value READ value WRITE setValue)

public:
	QExtIntContainer(int value=0);

	int value();

public slots:
	void setValue(int value);

signals:
	void valueChanged();
	void valueChanged(int);

protected:
	int _value;
};

class QExtDoubleContainer : public QObject {

	Q_OBJECT
	Q_PROPERTY(double value READ value WRITE setValue)

public:
	QExtDoubleContainer(double value=0.0);

	double value();

public slots:
	void setValue(double value);

signals:
	void valueChanged();
	void valueChanged(double);

protected:
	double _value;
};

class QExtSizeContainer : public QObject {

	Q_OBJECT
	Q_PROPERTY(QSize value READ value WRITE setValue)

public:
	QExtSizeContainer(QSize value=QSize());

	QSize value();

public slots:
	void setValue(QSize value);

signals:
	void valueChanged();
	void valueChanged(QSize);

protected:
	QSize _value;
};

// missing in qt
Q_DECLARE_METATYPE(qint8);

#endif /*QTUTILS_H_*/
