/* Copyright 2008 Thomas Bergwinkl
 *
 * This file is part of bergphoto.
 *
 * bergphoto is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * bergphoto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with bergphoto.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "SimpleImagePreviewWidget.h"

SimpleImagePreviewWidget::SimpleImagePreviewWidget(QWidget* parent) : QWidget(parent) {
	_formImagePreview.setupUi(this);

	_formImagePreview.horizontalSliderRotateAngle->setDoubleScale(10.0);

	_formImagePreview.horizontalSliderZoom->setDoubleScale(1000.0);

	_formImagePreview.horizontalSliderZoom->setDoubleValue(0.125);

	_filterChainBridge = new ImagePreviewFilterChainBridge(this);

	connect(_formImagePreview.checkBoxCropLines, SIGNAL(toggled(bool)), _formImagePreview.graphicsViewRender, SLOT(setViewCropLines(bool)));

	connect(_formImagePreview.horizontalSliderRotateAngle, SIGNAL(doubleValueChanged(double)), _formImagePreview.doubleSpinBoxRotateAngle, SLOT(setValue(double)));
	connect(_formImagePreview.doubleSpinBoxRotateAngle, SIGNAL(valueChanged(double)), _formImagePreview.horizontalSliderRotateAngle, SLOT(setDoubleValue(double)));

	connect(_formImagePreview.horizontalSliderZoom, SIGNAL(doubleValueChanged(double)), _formImagePreview.graphicsViewRender, SLOT(setScale(double)));

	connect(_formImagePreview.graphicsViewRender, SIGNAL(maxImageSizeChanged(QSize)), this, SLOT(maxImageSizeChange(QSize)));

	connect(_formImagePreview.graphicsViewRender, SIGNAL(scaleChanged(double)), _formImagePreview.horizontalSliderZoom, SLOT(setDoubleValue(double)));

	connect(_formImagePreview.spinBoxCropBottom, SIGNAL(editingFinished()), this, SLOT(updateCrop()));
	connect(_formImagePreview.spinBoxCropLeft, SIGNAL(editingFinished()), this, SLOT(updateCrop()));
	connect(_formImagePreview.spinBoxCropRight, SIGNAL(editingFinished()), this, SLOT(updateCrop()));
	connect(_formImagePreview.spinBoxCropTop, SIGNAL(editingFinished()), this, SLOT(updateCrop()));
}

SimpleImagePreviewWidget::~SimpleImagePreviewWidget() {
}

void SimpleImagePreviewWidget::setFilterChain(ImageFilterChain* filterChain) {
	_filterChainBridge->setImageFilterChain(filterChain);

	connect(_formImagePreview.spinBoxCropBottom, SIGNAL(valueChanged(int)), _filterChainBridge, SLOT(setCropBottom(int)));
	connect(_formImagePreview.spinBoxCropLeft, SIGNAL(valueChanged(int)), _filterChainBridge, SLOT(setCropLeft(int)));
	connect(_formImagePreview.spinBoxCropRight, SIGNAL(valueChanged(int)), _filterChainBridge, SLOT(setCropRight(int)));
	connect(_formImagePreview.spinBoxCropTop, SIGNAL(valueChanged(int)), _filterChainBridge, SLOT(setCropTop(int)));
	connect(_formImagePreview.doubleSpinBoxRotateAngle, SIGNAL(valueChanged(double)), _filterChainBridge, SLOT(setRotateAngle(double)));

	_formImagePreview.graphicsViewRender->setFilterChain(filterChain);
}

void SimpleImagePreviewWidget::maxImageSizeChange(QSize maxImageSize) {
	_maxImageSize = maxImageSize;

	updateCrop();
}

void SimpleImagePreviewWidget::updateCrop() {
	int width = _maxImageSize.width();
	int height = _maxImageSize.height();

	_formImagePreview.spinBoxCropTop->setRange(0, height-_formImagePreview.spinBoxCropBottom->value());
	_formImagePreview.spinBoxCropLeft->setRange(0, width-_formImagePreview.spinBoxCropRight->value());
	_formImagePreview.spinBoxCropBottom->setRange(0, height-_formImagePreview.spinBoxCropTop->value());
	_formImagePreview.spinBoxCropRight->setRange(0, width-_formImagePreview.spinBoxCropLeft->value());
}
