/* Copyright 2008 Thomas Bergwinkl
 *
 * This file is part of bergphoto.
 *
 * bergphoto is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * bergphoto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with bergphoto.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef SIMPLE_IMAGE_PREVIEW_WIDGET_H_
#define SIMPLE_IMAGE_PREVIEW_WIDGET_H_

#include <QWidget>

#include <ImageFilter.h>

#include <ui_widgetSimpleImagePreview.h>

class SimpleImagePreviewWidget : public QWidget {

	Q_OBJECT

public:
	SimpleImagePreviewWidget(QWidget* parent);
	virtual ~SimpleImagePreviewWidget();

	void setFilterChain(ImageFilterChain* filterChain);

public slots:
	void maxImageSizeChange(QSize maxImageSize);

	void updateCrop();

private:
	Ui::FormImagePreview _formImagePreview;
	ImagePreviewFilterChainBridge* _filterChainBridge;
	QSize _maxImageSize;
};

#endif /* SIMPLE_IMAGE_PREVIEW_WIDGET_H_ */
