/* Copyright 2008 Thomas Bergwinkl
 *
 * This file is part of bergphoto.
 *
 * bergphoto is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * bergphoto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with bergphoto.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef DEVELOPFILTER_H_
#define DEVELOPFILTER_H_

#include <ImageFilter.h>

class DevelopFilter : public ImageFilter {
public:
	static QString parameterOutputProfile;
	static QString profileSRgb;
	static QString profileProPhotoRgbLinear;
	static QString profileAdobeRgb;

	DevelopFilter();

	virtual ~DevelopFilter();

	virtual QString name();

	virtual bool accepts(ImageFormat inputFormat, ImageFormat outputFormat);

	virtual bool isParamterUsed(QString key);

	virtual bool isPropertyUsed(MetadataProperty* property);

	virtual ImageFormat prepare(MetadataResource* metadata, ImageFormat inputFormat, ImageFormat outputFormat);

	virtual Image* filter(Image* input, ImageFormat outputFormat);
};

#endif /* DEVELOPFILTER_H_ */
