/* Copyright 2008 Thomas Bergwinkl
 *
 * This file is part of bergphoto.
 *
 * bergphoto is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * bergphoto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with bergphoto.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "ResizeFilter.h"

ResizeFilter::ResizeFilter() {
}

ResizeFilter::~ResizeFilter() {
}

QString ResizeFilter::name() {
	return QString("ResizeFilter");
}

bool ResizeFilter::accepts(ImageFormat inputFormat, ImageFormat outputFormat) {
	return inputFormat.type() == RgbImage48::type() && outputFormat.type() == RgbImage48::type();
}

bool ResizeFilter::isParamterUsed(QString key) {
	if(key == "targetWidth" || key == "targetHeight" || key == "scale")
		return true;

	return false;
}

bool ResizeFilter::isPropertyUsed(MetadataProperty* property) {
	Q_UNUSED(property);

	return false;
}

ImageFormat ResizeFilter::prepare(MetadataResource* metadata, ImageFormat inputFormat, ImageFormat outputFormat) {
	Q_UNUSED(metadata);

	if(accepts(inputFormat, outputFormat)) {
		int targetWidth = _parameters.value("targetWidth").toInt();
		int targetHeight = _parameters.value("targetHeight").toInt();

		if(_parameters.contains("scale")) {
			double scale = _parameters.value("scale").toDouble();

			targetWidth = (int)(inputFormat.width()*scale);
			targetHeight = (int)(inputFormat.height()*scale);
		}

		return ImageFormat(outputFormat.type(), targetWidth, targetHeight);
	} else {
		return ImageFormat();
	}
}

Image* ResizeFilter::filter(Image* input, ImageFormat outputFormat) {
	ImageFormat targetFormat = prepare(input->metadata(), input->format(), outputFormat);

	if(targetFormat.type().isEmpty())
		return 0;

	int sourceWidth = input->width();
	int sourceHeight = input->height();
	int targetWidth = targetFormat.width();
	int targetHeight = targetFormat.height();

	RgbImage48* sourceImage = qobject_cast<RgbImage48*>(input);
	RgbImage48* targetImage = new RgbImage48(targetWidth, targetHeight);

	targetImage->setMetadata(sourceImage->metadata());

	for(int y=0; y<targetHeight; y++) {
		quint16* targetPixel = (quint16*)targetImage->dataStripe(y);

		for(int x=0; x<targetWidth; x++) {
			quint16* sourcePixel = (quint16*)sourceImage->dataOffset(x*sourceWidth/targetWidth, y*sourceHeight/targetHeight);

			targetPixel[0] = sourcePixel[0];
			targetPixel[1] = sourcePixel[1];
			targetPixel[2] = sourcePixel[2];

			targetPixel += 3;
		}
	}

	return targetImage;
}
