/* Copyright 2008 Thomas Bergwinkl
 *
 * This file is part of bergphoto.
 *
 * bergphoto is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * bergphoto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with bergphoto.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef ROTATECROPFILTER_H_
#define ROTATECROPFILTER_H_

#include <ImageFilter.h>

class RotateCropFilter : public ImageFilter {
public:
	static QString namespaceUri;
	static MetadataQName propertyRotateAngle;
	static MetadataQName propertyCropLeft;
	static MetadataQName propertyCropRight;
	static MetadataQName propertyCropTop;
	static MetadataQName propertyCropBottom;

	enum {
		InterpolateNearest = 0,
		InterpolateLinear = 1,
		InterpolateCubic = 2
	} Interpolation;

	RotateCropFilter();
	virtual ~RotateCropFilter();

	virtual QString name();

	virtual bool accepts(ImageFormat inputFormat, ImageFormat outputFormat);

	virtual bool isParamterUsed(QString key);

	virtual bool isPropertyUsed(MetadataProperty* property);

	virtual ImageFormat prepare(MetadataResource* metadata, ImageFormat inputFormat, ImageFormat outputFormat);

	virtual Image* filter(Image* input, ImageFormat outputFormat);

private:
	static void nearestNeighborInterpolation(RgbImage48* source, quint16* targetPixel, double x, double y);
	static inline quint16 bilinearInterpolation(quint16 p0, quint16 p1, quint16 p2, quint16 p3, double dx, double dy);
	static void bilinearInterpolation(RgbImage48* source, quint16* targetPixel, double x, double y);
	static inline double cubicInterpolation(quint16 p0, quint16 p1, quint16 p2, quint16 p3, double d);
	static inline quint16 cubicInterpolation(double p0, double p1, double p2, double p3, double d);
	static void bicubicInterpolation(RgbImage48* source, quint16* targetPixel, double x, double y);

	static RgbImage48* crop(RgbImage48* source, int cropLeft, int cropRight, int cropTop, int cropBottom);
	static RgbImage48* rotate90Crop(RgbImage48* source, int cropLeft, int cropRight, int cropTop, int cropBottom);
	static RgbImage48* rotate180Crop(RgbImage48* source, int cropLeft, int cropRight, int cropTop, int cropBottom);
	static RgbImage48* rotate270Crop(RgbImage48* source, int cropLeft, int cropRight, int cropTop, int cropBottom);
	static RgbImage48* rotateCrop(RgbImage48* source, double angle, int interpolation, int cropLeft, int cropRight, int cropTop, int cropBottom);
};

#endif /* ROTATECROPFILTER_H_ */
