/* Copyright 2008 Thomas Bergwinkl
 *
 * This file is part of bergphoto.
 *
 * bergphoto is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * bergphoto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with bergphoto.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef CANONCR2_H_
#define CANONCR2_H_

#include <QIODevice>
#include <QMap>
#include <QString>

#include <Image.h>
#include <ImageFilter.h>
#include <Metadata.h>

#include <RawFile.h>
#include <formats/Tiff.h>

class CanonCr2 {
public:
	static QString namespaceUri;

	static TiffMetadataQName propertyShotInfo;
	static TiffMetadataQName propertyBodyInfo;
	static TiffMetadataQName propertySensorInfo;
	static TiffMetadataQName propertyColorBalance;
	static TiffMetadataQName propertySensorPlanes;

	static MetadataQName propertyDefaultWhiteBalanceNeutral5200K;

	static QList<TiffMetadataQName> tiffMetadataQNames();

private:
	static QList<TiffMetadataQName> _tiffMetadataQNames;
};

class CanonCr2Image : public BayerImage16 {

	Q_OBJECT

public:
	CanonCr2Image(int width, int height);
	virtual ~CanonCr2Image();

	static QString type() {
		return QString("CanonCr2");
	}
};

class CanonCr2Reader : public TiffReader {
public:
	CanonCr2Reader(QIODevice* device);

	virtual MetadataNode* read(MetadataNode* parent=0);

protected:
	virtual MetadataQName tagQName(quint16 tag);
	virtual void parseMakerNote(MetadataNode* parent, quint32 offset);
	virtual void parseDirectory(MetadataNode* parent, quint32 offset);

private:
	quint32 _rawIfdOffset;

	static QMap<quint16, MetadataQName> _makerNodeTagMetadataQNameMap;
	static QMap<quint16, MetadataQName> makerNodeTagMetadataQNameMap();
};

class CanonCr2File : public RawFile {
public:
	CanonCr2File(QIODevice* device);
	virtual ~CanonCr2File();

	virtual MetadataDocument* readMetadata();
	virtual Image* readImage();
	virtual int thumbnailCount();
	virtual QImage thumnail(int n);

private:
	QIODevice* _device;
	CanonCr2Reader* _canonCr2Reader;
	quint32 _rawOffset;
	quint32 _rawLength;
	quint32 _tnsOffset;
	quint32 _tnsLength;
	quint32 _tnbOffset;
	quint32 _tnbLength;
};

class Cr2BayerConverter : public ImageFilter {
public:
	virtual QString name();

	virtual bool accepts(ImageFormat inputFormat, ImageFormat outputFormat);

	virtual bool isParamterUsed(QString key);

	virtual bool isPropertyUsed(MetadataProperty* property);

	virtual ImageFormat prepare(MetadataResource* metadata, ImageFormat inputFormat, ImageFormat outputFormat);

	virtual Image* filter(Image* input, ImageFormat outputFormat);
};

class CanonCr2MetadataCleanupTransform : public MetadataTransform {
public:
	virtual ~CanonCr2MetadataCleanupTransform();

	virtual MetadataNode* transform(MetadataNode* source);
};

#endif /*CANONCR2_H_*/
