/* Copyright 2008 Thomas Bergwinkl
 *
 * This file is part of bergphoto.
 *
 * bergphoto is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * bergphoto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with bergphoto.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef DNG_H_
#define DNG_H_

#include <QIODevice>
#include <QMap>
#include <QString>

#include <Image.h>
#include <Metadata.h>
#include <RawFile.h>
#include <formats/Tiff.h>

class DNG {
public:
	static QString namespaceUri;

	static TiffMetadataQName propertyDNGVersion;
	static TiffMetadataQName propertyDNGBackwardVersion;
	static TiffMetadataQName propertyUniqueCameraModel;
	static TiffMetadataQName propertyLocalizedCameraModel;
	static TiffMetadataQName propertyCFAPlaneColor;
	static TiffMetadataQName propertyCFALayout;
	static TiffMetadataQName propertyBlackLevelRepeatDim;
	static TiffMetadataQName propertyBlackLevel;
	static TiffMetadataQName propertyBlackLevelDeltaH;
	static TiffMetadataQName propertyBlackLevelDeltaV;
	static TiffMetadataQName propertyWhiteLevel;
	static TiffMetadataQName propertyDefaultScale;
	static TiffMetadataQName propertyDefaultCropOrigin;
	static TiffMetadataQName propertyDefaultCropSize;
	static TiffMetadataQName propertyColorMatrix1;
	static TiffMetadataQName propertyColorMatrix2;
	static TiffMetadataQName propertyCameraCalibration1;
	static TiffMetadataQName propertyCameraCalibration2;
	static TiffMetadataQName propertyAnalogBalance;
	static TiffMetadataQName propertyAsShotNeutral;
	static TiffMetadataQName propertyBaselineExposure;
	static TiffMetadataQName propertyBaselineNoise;
	static TiffMetadataQName propertyBaselineSharpness;
	static TiffMetadataQName propertyBayerGreenSplit;
	static TiffMetadataQName propertyLinearResponseLimit;
	static TiffMetadataQName propertyCameraSerialNumber;
	static TiffMetadataQName propertyLensInfo;
	static TiffMetadataQName propertyAntiAliasStrength;
	static TiffMetadataQName propertyShadowScale;
	static TiffMetadataQName propertyDNGPrivateData;
	static TiffMetadataQName propertyCalibrationIlluminant1;
	static TiffMetadataQName propertyCalibrationIlluminant2;
	static TiffMetadataQName propertyBestQualityScale;
	static TiffMetadataQName propertyRawDataUniqueID;
	static TiffMetadataQName propertyOriginalRawFileName;
	static TiffMetadataQName propertyOriginalRawFileData;
	static TiffMetadataQName propertyActiveArea;
	static TiffMetadataQName propertyMaskedAreas;

	static QList<TiffMetadataQName> tiffMetadataQNames();

private:
	static QList<TiffMetadataQName> _tiffMetadataQNames;
};

class DNGReader : public TiffReader {
public:
	DNGReader(QIODevice* device);

protected:
	virtual MetadataQName tagQName(quint16 tag);
	virtual QVariant tagValue(quint16 tag, QVariant value);

private:
	static QMap<quint16, MetadataQName> _dngTagMetadataQNameMap;
	static QMap<quint16, MetadataQName> dngTagMetadataQNameMap();
};

class DNGFile : public RawFile {
public:
	DNGFile(QIODevice* device);
	virtual ~DNGFile();

	virtual MetadataDocument* readMetadata();
	virtual Image* readImage();
	virtual int thumbnailCount();
	virtual QImage thumnail(int n);

private:
	QIODevice* _device;
	DNGReader* _dngReader;
	QList<int> _tnIndex;
	QList<quint32> _tnOffsets;
	QList<quint32> _tnLengths;
};

class DNGMetadataCleanupTransform : public MetadataTransform {
public:
	virtual ~DNGMetadataCleanupTransform();

	virtual MetadataNode* transform(MetadataNode* source);
};

#endif /*DNG_H_*/
