/* Copyright 2008 Thomas Bergwinkl
 *
 * This file is part of bergphoto.
 *
 * bergphoto is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * bergphoto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with bergphoto.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef LIBRAWFILE_H_
#define LIBRAWFILE_H_

#include <RawFile.h>

#include <libraw.h>

class LibRawFile : public RawFile {
public:
	LibRawFile(QIODevice* device);
	virtual ~LibRawFile();

	virtual MetadataDocument* readMetadata();
	virtual Image* readImage();
	virtual int thumbnailCount();
	virtual QImage thumnail(int n);

private:
	LibRaw _libRaw;
};

#endif /* LIBRAWFILE_H_ */
